/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.ui.bonsai.config.ResourcesNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.config.WorkareaConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.AbstractTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.util.FilterResult;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import java.util.Set;

public class ResourceTreeNode
extends AbstractTreeNode {
    private String display;

    protected ResourceTreeNode(ResourceTreeNode clonee, BonsaiTreeNode parent) {
        this(clonee, parent, clonee.getXMLKey());
    }

    protected ResourceTreeNode(ResourceTreeNode clonee, BonsaiTreeNode parent, String idPostfix) {
        super(clonee, parent, idPostfix);
        this.display = clonee.display;
    }

    public ResourceTreeNode(ResourcesNodeConfigBean configBean, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters) {
        this(configBean, parent, defaultWorkarea, filters, configBean.getKey());
    }

    public ResourceTreeNode(ResourcesNodeConfigBean configBean, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters, String idPostfix) {
        super(configBean, parent, defaultWorkarea, filters, idPostfix);
        this.display = configBean.getDisplay();
    }

    public final boolean isShown(UserObject userObj, boolean inTree) {
        boolean passesFilters;
        if (!this.isPermitted(userObj.getUserRoles())) {
            return false;
        }
        FilterResult filterResult = this.getFilterResult(userObj, inTree);
        boolean bl = passesFilters = !filterResult.isFilteredOut();
        if (filterResult.hasPriority() && !passesFilters) {
            return false;
        }
        if (this.display.equalsIgnoreCase("always")) {
            return this.hasShownChildren(userObj) || passesFilters;
        }
        if (!inTree && this.display.equalsIgnoreCase("leaf")) {
            return passesFilters;
        }
        if (this.display.equalsIgnoreCase("notempty")) {
            return this.hasShownChildren(userObj);
        }
        return false;
    }

    protected boolean isPermitted(Set userRoles) {
        return true;
    }

    public BonsaiTreeNode getCopy(BonsaiTreeNode parent, boolean copyChildren) {
        ResourceTreeNode node = new ResourceTreeNode(this, parent);
        if (copyChildren) {
            node.copyChildren(this);
        }
        return node;
    }
}

